*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Phorate oxon sulfoxide                               *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";
libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data phorateoxonsulfoxide;
     set epa.phorateoxonsulfoxide;
run;
proc sort data=phorateoxonsulfoxide;
     by id;
run;

/*
ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfoxide - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Phorateoxonsulfoxide);
ods rtf close;
*/

*==> Human vs. rat;

title2 "final model 2b: a model with same random effects of a and b for both species";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=PhorateOxonSulfoxide itdetails tech=newrap lis=3;
      PARMS ha=1.0736		hb=2.1343
			ra=1.2393		rb=2.0706
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=0.1776 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
  	  predict pred2 out=Resid_HR;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfoxide human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=PhorateOxonSulfoxide, model=2)
ods rtf close;
*%Calculate_Ki(chemical=PhorateOxonSulfoxide, Hadj=1e-5, Radj=1e-5);

/* 
title1 "final model 3: a model with different random effects between species - different order of magnitute for rhb and rrb";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=PhorateOxonSulfoxide  method=firo tech=newrap lis=3 maxiter=10000;
      PARMS ha=0.9833
			hb=1.9440
			ra= 2.1219
			rb= 4.0497
			gha= 2.6617	ghab=6.0797		ghb=1.4469
			gra=1.3814	grab=3.0726	grb=6.8508
			S2E=0.1347;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha*1e-1, 
												 		 ghab*1e-1, ghb,
														 0,    	  0,   gra*10,
														 0,       0,   grab*10, grb*10]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfoxide human-rat (Exponent model).rtf" startpage=no;
%DiagnosticsHR(chemical=PhorateOxonSulfoxide, model=3)
ods rtf close;

*/


*==> Adult vs. Infant;


title "CEB final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=phorateoxonsulfoxide(where=(Human=1)) tech=nrridg lis=3 method=firo;
      PARMS ada=1.0288	adB=0.2037
			ia=.882 iB=0.1748
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=0.09673 / best=50;
			gha=gh1*gh1*100;
			ghab=gh1*gh12;
			ghb=gh12*gh12/100+gh2*gh2;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-5);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/(adb*1e-4))/(ia/(ib*1e-5));
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  estimate "gha" gh1*gh1*100;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12/100+gh2*gh2;
	  id pred2;
      predict pred2 out=Resid_AI;
run;

%let factor=0.00001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfoxide Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=PhorateOxonSulfoxide, model=2);
ods rtf close;

/*
*===> Exponent's model;
title "Exponent's final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phorateoxonsulfoxide(where=(Human=1)) itdetails tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=1.0288	adB=0.2037
			ia=.882 iB=0.1748
			gha=2.9991 	ghab=0.6904	ghb=0.1650
			S2E=0.09673;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfoxide Adult-Infant (Exponent's model).rtf" startpage=no;
%DiagnosticsAI(chemical=PhorateOxonSulfoxide, model=2);
ods rtf close;
*/

*===> Male vs. Female;



title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=phorateoxonsulfoxide(where=(Human=1)) method=firo itdetails tech=newrap lis=3 maxiter=100000;
      PARMS ma=.8982 mb= 1.8428
			fa=1.1235 fB=2.1996
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=.9819  / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12*10;
			ghb=gh12*gh12*100+gh2*gh2;
			rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF;  
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12*10;
	  estimate "ghb" gh12*gh12*100+gh2*gh2;
	  id pred2;
		predict pred2 out=Resid_MF;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfoxide Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=PhorateOxonSulfoxide, model=2);
ods rtf close;


*===> Caucasian vs. Other Races;





title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=phorateoxonsulfoxide(where=(Human=1)) method=firo itdetails tech=newrap lis=3 maxiter=100000;
      PARMS ca=.8524	cB=.1640
			ora=.1.4055 orB=0.2896
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=.9681 / best= 50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2/100;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-4 + H_I__M*caucasian + rorb*otherrace*1e-4 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2/100;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfoxide Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=PhorateOxonSulfoxide, model=2);
ods rtf close;

%resids